// Климат-контроль МАРС-1
#define _LCD_TYPE 1 // Говорим что дисплей подключен по I2C
#include <LCD_1602_RUS_ALL.h> // Подключаем библиотеку для дисплея
#include <DHT.h> // Подключаем библиотеку для датчика

LCD_1602_RUS lcd(0x27, 16, 2); // LCD дисплей
DHT dht25(25, 11); // DHT11 на пине 25

void setup() {
  lcd.init(); // Инициализация дисплея
  lcd.backlight(); // Включить подсветку
  dht25.begin(); // Запуск датчика
  
  // Приветствие
  lcd.clear(); // Очищаем экран
  lcd.setCursor(0, 0); // Ставим курсор в начало первой строки
  lcd.print("КЛИМАТ МАРС-1"); // Пишем название
  lcd.setCursor(0, 1); // Переходим на вторую строку
  lcd.print("Система готова"); // Пишем что система работает
  delay(2000); // Ждем 2 секунды
  lcd.clear(); // Очищаем экран
}

void loop() {
  float temp = dht25.readTemperature(); // Читаем температуру
  float humidity = dht25.readHumidity(); // Читаем влажность
  
  // Преобразуем float в строку
  char tempStr[6]; // Создаем место для текста температуры
  char humStr[6]; // Создаем место для текста влажности
  dtostrf(temp, 4, 1, tempStr); // Превращаем число в текст
  dtostrf(humidity, 4, 1, humStr); // Превращаем число в текст
  
  // Первая строка - температура
  lcd.setCursor(0, 0); // Идем в начало первой строки
  lcd.print("Темп: "); // Пишем "Темп: "
  lcd.print(tempStr); // Показываем температуру
  lcd.print("°C"); // Добавляем градусы
  
  // Вторая строка - влажность
  lcd.setCursor(0, 1); // Идем в начало второй строки
  lcd.print("Влаж: "); // Пишем "Влаж: "
  lcd.print(humStr); // Показываем влажность
  lcd.print("%"); // Добавляем проценты
  
  delay(200); // Обновление 5 раз в секунду
}
