// Система идентификации МАРС-1
#include <Wire.h>
#include <Adafruit_PN532.h>

// Настройка пинов подключения
#define SDA_PIN 21
#define SCL_PIN 22
Adafruit_PN532 nfc(SDA_PIN, SCL_PIN);

// База данных карт доступа
// ЗАМЕНИТЬ НА СВОИ ДАННЫЕ
String commander_uid = "c3fd53fa"; // UID карты командира
String engineer_uid = "06f38e75";  // UID карты инженера
String master_uid = "06f38e75";  // UID карты инженера

String nfc_str = ""; // Текущая считанная карта

void setup() {
  // Запуск связи с компьютером
  Serial.begin(115200);
  Serial.println("Инициализация PN532...");
  
  // Запуск NFC модуля
  nfc.begin();

  // Проверка работы модуля
  uint32_t version = nfc.getFirmwareVersion();
  if (!version) {
    Serial.println("NFC модуль не найден");
    while (1); // Останавливаем программу
  }

  // Настройка модуля
  nfc.SAMConfig();
  pinMode(23, OUTPUT); // Зуммер
  delay(500);
  Serial.println("Система доступа МАРС-1 запущена");
}

void loop() {
  uint8_t uid[7]; // Место для номера карты
  uint8_t uidLength; // Длина номера

  // Проверка новой карты
  if (!nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, uid, &uidLength)) {
    delay(50);
    return; // Нет карты - ждём
  }

  // Чтение UID
  nfc_str = "";
  for (uint8_t i = 0; i < uidLength; i++) {
    if (uid[i] < 16) nfc_str += "0"; // Добавляем 0 для однозначных чисел
    nfc_str += String(uid[i], HEX);
  }

  // Вывод информации
  Serial.print("Запрос доступа - UID: ");
  Serial.println(nfc_str);

  // Проверка доступа и звуковой сигнал
  if (nfc_str == commander_uid) {
    // Доступ командира
    Serial.println("КОМАНДИР - Доступ разрешен!");
    
    // Звук успеха - два коротких высоких сигнала
    tone(23, 2000); // Высокий тон
    delay(100);
    noTone(23);
    delay(50);
    tone(23, 2000);
    delay(100);
    noTone(23);
    
  } else if (nfc_str == engineer_uid) {
    // Доступ инженера
    Serial.println("ИНЖЕНЕР - Доступ разрешен!");
    
    // Звук успеха - два коротких высоких сигнала
    tone(23, 2000); // Высокий тон
    delay(100);
    noTone(23);
    delay(50);
    tone(23, 2000);
    delay(100);
    noTone(23);
    
  } else if (nfc_str == master_uid) {
    // Доступ инженера
    Serial.println("Мастер - Доступ разрешен!");
    
    // Звук успеха - два коротких высоких сигнала
    tone(23, 2000); // Высокий тон
    delay(100);
    noTone(23);
    delay(50);
    tone(23, 2000);
    delay(100);
    noTone(23);
    delay(50);
    tone(23, 2000);
    delay(100);
    noTone(23);

    
  }else {
    // Доступ запрещен
    Serial.println("НЕИЗВЕСТНЫЙ - Требуется проверка!");
    
    // Звук ошибки - один длинный низкий сигнал
    tone(23, 500); // Низкий тон
    delay(1000);
    noTone(23);
  }
  
  delay(500); // Пауза перед следующим считыванием
}
