// Система идентификации и управления шлюзом МАРС-1
#include <Wire.h>
#include <Adafruit_PN532.h>
#include <ESP32Servo.h>

// Настройка пинов подключения
#define SDA_PIN 21
#define SCL_PIN 22
Adafruit_PN532 nfc(SDA_PIN, SCL_PIN);

// Сервопривод шлюза
Servo servo_18;

// База данных карт доступа
//ЗАМЕНИ НА СВОИ ДАННЫЕ!
String commander_uid = "c3fd53fa"; // UID карты командира
String engineer_uid = "06f38e75";  // UID карты инженера

String nfc_str = ""; // Текущая считанная карта

// Углы шлюза
const int door_close = 5;   // Закрыто (герметично)
const int door_open = 100;  // Открыто (проход)

void setup() {
  // Запуск связи с компьютером
  Serial.begin(115200);
  Serial.println("Инициализация системы МАРС-1...");
  
  // Запуск NFC модуля
  nfc.begin();
  uint32_t version = nfc.getFirmwareVersion();
  if (!version) {
    Serial.println("NFC модуль не найден");
    while (1);
  }
  nfc.SAMConfig();
  
  // Калибровка сервопривода
  servo_18.attach(18, 500, 2500);
  servo_18.write(door_close); // Начальная позиция - закрыто
  
  // Настройка зуммера
  pinMode(23, OUTPUT);
  
  delay(500);
  Serial.println("Шлюз МАРС-1 готов к работе!");
  Serial.println("Шлюз закрыт и герметизирован");
}

void loop() {
  uint8_t uid[7];
  uint8_t uidLength;

  // Проверка новой карты
  if (!nfc.readPassiveTargetID(PN532_MIFARE_ISO14443A, uid, &uidLength)) {
    delay(50);
    return; // Нет карты - ждём
  }

  // Чтение UID
  nfc_str = "";
  for (uint8_t i = 0; i < uidLength; i++) {
    if (uid[i] < 16) nfc_str += "0";
    nfc_str += String(uid[i], HEX);
  }

  // Журнал доступа
  Serial.print("Карта обнаружена: ");
  Serial.println(nfc_str);

  // Проверка доступа
  if (nfc_str == commander_uid) {
    Serial.println("КОМАНДИР - Доступ разрешен!");
    openDoor(); // Открыть шлюз
    
  } else if (nfc_str == engineer_uid) {
    Serial.println("ИНЖЕНЕР - Доступ разрешен!");
    openDoor(); // Открыть шлюз
    
  } else {
    Serial.println("НЕИЗВЕСТНЫЙ - Доступ запрещен!");
    accessDenied(); // Сигнал отказа
  }
  
  delay(500);
}

// Функция открытия шлюза
void openDoor() {
  // Звук успеха
  tone(23, 2000);
  delay(100);
  noTone(23);
  delay(50);
  tone(23, 2000);
  delay(100);
  noTone(23);
  
  // Цикл открытия шлюза
  Serial.println("Открытие шлюза...");
  servo_18.write(door_open); // Открыть
  delay(3000); // Ждать 3 сек для прохода
  
  // Предупреждающий сигнал перед закрытием
  Serial.println("Внимание! Закрытие шлюза...");
  tone(23, 1500);
  delay(200);
  noTone(23);
  delay(200);
  tone(23, 1500);
  delay(200);
  noTone(23);
  
  // Закрытие шлюза
  servo_18.write(door_close); // Закрыть
  delay(1000); // Время на закрытие
  Serial.println("Шлюз герметизирован!");
  Serial.println("Цикл завершён!");
}

// Функция отказа в доступе
void accessDenied() {
  // Звук ошибки
  tone(23, 500);
  delay(1000);
  noTone(23);
  Serial.println("Шлюз остается закрытым");
}
