// Автоматическая газовая тревога МАРС-1
void setup() {
  Serial.begin(115200); // Связь с центром управления
  pinMode(23, OUTPUT); // P-зуммер тревоги
  pinMode(32, INPUT); // Датчик газа MQ-4
}

void loop() {
  int gasLevel = analogRead(32); // Чтение концентрации
  
  // КРИТИЧЕСКИЙ УРОВЕНЬ ОПАСНОСТИ!
  if (gasLevel > 2000) {
    // АКТИВАЦИЯ ТРЕВОГИ!
    tone(23, 1000); // Сирена 1000 Гц
    delay(1000); // Звучит 1 секунду
    Serial.println("ТРЕВОГА! ОПАСНАЯ КОНЦЕНТРАЦИЯ!");
  } else {
    noTone(23); // Тревога отключена
  }
  
  // Передача данных в центр управления
  Serial.print("Уровень газа: ");
  Serial.println(gasLevel);
  delay(1000); // Проверка каждую секунду
}
